<?php


namespace App\Http\Controllers;
use App\Traits\UploadTrait;

use App\Client;
use Illuminate\Http\Request;


use Auth;


class ClientController extends Controller
{
    public function __construct(){
        return $this->middleware('auth');
    }

    use UploadTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $clients = Client::latest()->where('user_id', Auth::user()->id)->paginate(5);
        return view('clients.index', compact('clients'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $client = new Client();
        
        $client->user_id = Auth::user()->id;
        $client->company = $request->input('company');
        $client->responsable = $request->input('responsable');
        $client->email = $request->input('email');
        $client->telContact = $request->input('telContact');
        $client->tel = $request->input('tel');

        $client->site = $request->input('site');
        $client->adresse = $request->input('adresse');
        $client->ville = $request->input('ville');
        $client->zip = $request->input('zip');

        $image = $request->file('image');
            // Make a image name based on user name and current timestamp
            $name = str_slug($request->input('company')).'_'.time();
            // Define folder path
            $folder = '/uploads/clients/';
            // Make a file path where image will be stored [ folder path + file name + file extension]
            $filePath = $folder . $name. '.' . $image->getClientOriginalExtension();
            // Upload image
            $this->uploadOne($image, $folder, 'public', $name);
            // Set user profile image path in database to filePath
            $client->image = $filePath;

        $client->save();

        return redirect('Clients')->with(['status' => 'Client ajoutée avec succée.']);
        
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function show(Client $client)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function edit(Client $client)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Client $client)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function destroy(Client $client, $id)
    {
        //
        $client = Client::find($id);
        $client->delete();

        return redirect('Clients')->with('status','Client supprimé avec succée');
    }

    

}
