<?php

namespace App\Http\Controllers;

use App\repertory;
use App\Client;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class RepertoryController extends Controller
{
    public function __construct(){
        return $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $rep = repertory::all();
        return view('repertories.index', compact('rep'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $repertory = new repertory();

        $repertory->client_id = $idd = $request->input('client_id');
        $repertory->moisLet = $request->input('moisLet');
        $repertory->annee = $request->input('annee');

        

        $repertory->save();
        
        return redirect('ListRepertory/'.$idd)->with(['status' => 'Client ajoutée avec succée.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\repertory  $repertory
     * @return \Illuminate\Http\Response
     */
    public function show(repertory $repertory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\repertory  $repertory
     * @return \Illuminate\Http\Response
     */
    public function edit(repertory $repertory)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\repertory  $repertory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, repertory $repertory)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\repertory  $repertory
     * @return \Illuminate\Http\Response
     */
    public function destroy(repertory $repertory)
    {
        //
    }

    public function repertory($id)
    {
        //
        $annee = DB::table('repertories')->groupBy('annee')->where('client_id', $id)->get();
        foreach( $annee as $k=>$v):
            $annee[$k]->mois = DB::table('repertories')->where(array('annee'=>$v->annee,'client_id'=>$id))->get();
        endforeach;
        $rep = repertory::all()->where('client_id', $id);
        $company = Client::find($id);

        
        //return view('repertories.index', compact('rep'));
        return view('repertories.index', [
            'rep' => $rep, 
            'idd' => $id, 
            'ans' => $annee,
            'company' => $company
            
            ]);
        
    }

}
